﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Public Sub New()
        InitializeComponent()
        UpdateTextBlock()
    End Sub


    Private Sub UpdateTextBlock()
        txtblk.Text = String.Format("pt1 = {0:F2}" & vbLf & "pt2 = {1:F2}",
                                    NormalizePoint(dragger1Geometry.Center),
                                    NormalizePoint(dragger2Geometry.Center))
    End Sub


    Private Function NormalizePoint(ByVal pt As Point) As Point
        Return New Point(pt.X / 400, pt.Y / 400)
    End Function


    Protected Overrides Sub OnManipulationDelta(ByVal args As ManipulationDeltaEventArgs)
        Dim translation = args.DeltaManipulation.Translation

        If args.ManipulationContainer Is dragger1 Then
            Dim pt As New Point(Clamp(dragger1Geometry.Center.X + translation.X),
                                Clamp(dragger1Geometry.Center.Y + translation.Y))

            dragger1Geometry.Center = pt
            bezierSegment.Point1 = pt
            tangentLine1.Point = pt
            UpdateTextBlock()
        End If
        If args.ManipulationContainer Is dragger2 Then
            Dim pt As New Point(Clamp(dragger2Geometry.Center.X + translation.X),
                                Clamp(dragger2Geometry.Center.Y + translation.Y))

            dragger2Geometry.Center = pt
            bezierSegment.Point2 = pt
            tangentLine2.Point = pt
            UpdateTextBlock()
        End If

        MyBase.OnManipulationDelta(args)
    End Sub


    Private Function Clamp(ByVal input As Double) As Double
        Return Math.Max(0, Math.Min(400, input))
    End Function


    Private Sub OnAppbarAnimateButtonClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim controlPoint1 = NormalizePoint(dragger1Geometry.Center)
        Dim controlPoint2 = NormalizePoint(dragger2Geometry.Center)

        splineKeyFrame1.KeySpline = New KeySpline()
        splineKeyFrame1.KeySpline.ControlPoint1 = controlPoint1
        splineKeyFrame1.KeySpline.ControlPoint2 = controlPoint2

        splineKeyFrame2.KeySpline = New KeySpline()
        splineKeyFrame2.KeySpline.ControlPoint1 = controlPoint1
        splineKeyFrame2.KeySpline.ControlPoint2 = controlPoint2

        splineKeyFrame3.KeySpline = New KeySpline()
        splineKeyFrame3.KeySpline.ControlPoint1 = controlPoint1
        splineKeyFrame3.KeySpline.ControlPoint2 = controlPoint2

        splineKeyFrame4.KeySpline = New KeySpline()
        splineKeyFrame4.KeySpline.ControlPoint1 = controlPoint1
        splineKeyFrame4.KeySpline.ControlPoint2 = controlPoint2

        storyboard.Begin()
    End Sub
End Class
